//
// This file is part of MorphoGraphX - https://www.MorphoGraphX.org  (@RichardSmithLab)
//
// MorphoGraphX development is led by the Richard S. Smith lab at the John Innes Centre, Norwich, UK
//
// If you use MorphoGraphX in your work, please cite:
//   https://doi.org/10.7554/eLife.72601
//
// For support please see the image.sc forum:
//   https://forum.image.sc/tag/MorphoGraphX
//
// MorphoGraphX is copyright by its authors, contributors, and/or their employers.
//
// MorphoGraphX is free software, and is licensed under the terms of the 
// GNU General Public License https://www.gnu.org/licenses/.
//
#ifndef ITKREGISTRATION_HPP
#define ITKREGISTRATION_HPP

#include <ITKConfig.hpp>
#include <ITKProcess.hpp>

namespace mgx
{
  
  class mgxITK_EXPORT ITKDemonsRegistration : public Process 
	{
  public:
    ITKDemonsRegistration(const Process& process) : Process(process) 
    {
	  setName("Stack/ITK/Registration/ITK Demons Registration");
	  setDesc("Register the current image with the current one on the other stack");
	  setIcon(QIcon(":/images/Blur.png"));

	  addParm("Deformation File","Deformation File","deformation.vtk",booleanChoice());
	  addParm("Threshold at mean intensity","Threshold at mean intensity","Yes");
	  addParm("# Histogram levels","# Histogram levels","1024");
	  addParm("# Match points","# Match points","7");
	  addParm("# Iterations","# Iterations","150");
	  addParm("Sigma","Sigma","1.0");
		
		
		}
  
    bool run()
    {
      Stack* stk = currentStack();
      Stack* ref_stk = stack(stk->id() == 0 ? 1 : 0);
      Store* ref = ref_stk->currentStore();
      return run(ref, stk, parm("Deformation File"), stringToBool(parm("Threshold at mean intensity")), parm("# Histogram levels").toInt(), 
                                  parm("# Match points").toInt(), parm("# Iterations").toInt(), parm("Sigma").toFloat());
    }
  
    bool run(const Store* reference, Stack* image, QString output, bool thresholdAtMean, 
                        int nbHistLevels, int nbMatchPoints, int nbIterations, float sigma);

  };
}

#endif
