//
// This file is part of MorphoGraphX - https://www.MorphoGraphX.org  (@RichardSmithLab)
//
// MorphoGraphX development is led by the Richard S. Smith lab at the John Innes Centre, Norwich, UK
//
// If you use MorphoGraphX in your work, please cite:
//   https://doi.org/10.7554/eLife.72601
//
// For support please see the image.sc forum:
//   https://forum.image.sc/tag/MorphoGraphX
//
// MorphoGraphX is copyright by its authors, contributors, and/or their employers.
//
// MorphoGraphX is free software, and is licensed under the terms of the 
// GNU General Public License https://www.gnu.org/licenses/.
//
#ifndef ITKSINK_HPP
#define ITKSINK_HPP

#include <ITKConfig.hpp>
#include <ITKProcess.hpp>

namespace mgx
{
  class mgxITK_EXPORT ITKVTKWriter : public Process {
  public:
    ITKVTKWriter(const Process& process) : Process(process) 
    {
	  setName("Stack/ITK/System/ITK VTK Writer");
	  setDesc("Write a VTK Image File");
	  setIcon(QIcon(":/images/save.png"));

	  addParm("Filename","Filename","");
	}
  
    bool run()
    {
      if(!checkState().store(STORE_NON_EMPTY))
        return false;
      Stack* s = currentStack();
      Store* input = s->currentStore();
      bool res = run(input, parm("Filename"));
      return res;
    }
  
    bool run(const Store* input, QString filename);
  };
}

#endif
