//
// This file is part of MorphoGraphX - https://www.MorphoGraphX.org  (@RichardSmithLab)
//
// MorphoGraphX development is led by the Richard S. Smith lab at the John Innes Centre, Norwich, UK
//
// If you use MorphoGraphX in your work, please cite:
//   https://doi.org/10.7554/eLife.72601
//
// For support please see the image.sc forum:
//   https://forum.image.sc/tag/MorphoGraphX
//
// MorphoGraphX is copyright by its authors, contributors, and/or their employers.
//
// MorphoGraphX is free software, and is licensed under the terms of the 
// GNU General Public License https://www.gnu.org/licenses/.
//
#ifndef ITKSOURCE_HPP
#define ITKSOURCE_HPP

#include <ITKConfig.hpp>
#include <ITKProcess.hpp>
#include <ui_ImportStack.h>
#include <itkImageFileReader.h>

namespace mgx
{
  typedef itk::Image<unsigned short int, 5> U5ImageType;
  typedef itk::ImageFileReader<U5ImageType> ReaderType;
  
  class mgxITK_EXPORT ITKImageReader : public Process {
    Q_OBJECT
  public:
    ITKImageReader(const Process& process) : Process(process) 
    {
	  setName("Stack/ITK/System/ITK Image Reader");
	  setDesc("Read a 3D image from a single file");
	  setIcon(QIcon(":/images/open.png"));


	  addParm("Filename","Filename","");
	  addParm("Store","Store","Main",storeChoice());
	  addParm("Stack number","Stack number","0");	
		}
  
    bool initialize(QWidget* parent);
  
    bool run();
    bool run(Stack* stack, Store* store, QString filename);
   
  protected:
    void LoadSeries(bool next);
  
  protected slots:
    void NextSeriesSlot() { LoadSeries(true); };
    void PrevSeriesSlot() { LoadSeries(false); };
  
  protected:
    QString filename;
    Point5i size;
    Point5f step;
  
    QString pixelType;
    int componentSize;
    int components;
  
    int selectSeries;
    int selectComponent;
    int selectChannel;
    int selectTimePoint;
  
    Ui_ImportStackDialog* ui;
    itk::ImageIOBase::Pointer imageIO;
  };
}

#endif
