//
// This file is part of MorphoGraphX - https://www.MorphoGraphX.org  (@RichardSmithLab)
//
// MorphoGraphX development is led by the Richard S. Smith lab at the John Innes Centre, Norwich, UK
//
// If you use MorphoGraphX in your work, please cite:
//   https://doi.org/10.7554/eLife.72601
//
// For support please see the image.sc forum:
//   https://forum.image.sc/tag/MorphoGraphX
//
// MorphoGraphX is copyright by its authors, contributors, and/or their employers.
//
// MorphoGraphX is free software, and is licensed under the terms of the 
// GNU General Public License https://www.gnu.org/licenses/.
//

#ifndef MGX_SUBDIVIDE_HPP
#define MGX_SUBDIVIDE_HPP

/**
 * \file MGXSubdivide.hpp
 *
 * Subdivide object for built in MGX data
 */

#include <Subdivide.hpp>
#include <Mesh.hpp>

namespace mgx
{
  // Class to subdivide MGX data
  class mgx_EXPORT MGXSubdivide : virtual public Subdivide
  {
    public:
      MGXSubdivide(Mesh *m) : mesh(m) {}

    protected:
      virtual bool updateCellData(cell c, cell cl, cell cr);
      virtual bool updateEdgeData(vertex l, vertex v, vertex r, double s);
    
    private: 
      Mesh *mesh;
  };
}

#endif

