//
// This file is part of MorphoGraphX - https://www.MorphoGraphX.org  (@RichardSmithLab)
//
// MorphoGraphX development is led by the Richard S. Smith lab at the John Innes Centre, Norwich, UK
//
// If you use MorphoGraphX in your work, please cite:
//   https://doi.org/10.7554/eLife.72601
//
// For support please see the image.sc forum:
//   https://forum.image.sc/tag/MorphoGraphX
//
// MorphoGraphX is copyright by its authors, contributors, and/or their employers.
//
// MorphoGraphX is free software, and is licensed under the terms of the 
// GNU General Public License https://www.gnu.org/licenses/.
//
#ifndef MESH_PROCESS_MULTI_HPP
#define MESH_PROCESS_MULTI_HPP

#include <Process.hpp>

namespace mgx
{
  ///\addtogroup MeshProcess
  ///@{
  /**
   * \class CopySwapMeshes <MeshProcessMulti.hpp>
   *
   * Copy or swap meshes between stack 1 and 2.
   */
  class mgxBase_EXPORT CopySwapMeshes : public Process 
  {
  public:
    CopySwapMeshes(const Process& process) : Process(process) 
    {
	  setName("Mesh/MultiMesh/Swap or Copy Mesh 1 and 2");
	  setDesc("Copy or Swap Mesh 1 and 2");
	  setIcon(QIcon(":/images/CopySwapStacks.png"));

	  addParm("Action","Action","1 -> 2", QStringList() << "1 -> 2" << "1 <- 2" << "1 <-> 2");	
	}
  
    bool run()
    {
      bool res = run(parm("Action"));
      return res;
    }
  
    bool run(const QString& actionStr);

  };

  /**
   * \class MeshAddOtherMesh <MeshProcessMulti.hpp>
   *
   * copy all vertices, edges and triangles from the other mesh into the active mesh
   */
  class mgxBase_EXPORT MeshAddOtherMesh : public Process 
  {
  public:
    MeshAddOtherMesh(const Process& process) : Process(process) 
    {
	  setName("Mesh/MultiMesh/Add Other Mesh");
	  setDesc("Adds all vertices and edges from the other mesh to the active mesh. Relabel if vertices have identical labels.");
	  setIcon(QIcon(":/images/CopySwapStacks.png"));

	  addParm("Relabel cells","Relabel cells","Yes",booleanChoice());
	}
  
    bool run()
    {

      const Stack *s1 = currentStack();
      const Stack *s2 = otherStack();
      Mesh* m = currentMesh();
      Mesh* m2 = otherMesh();
      bool res = run(s1, s2, m, m2, stringToBool(parm("Relabel cells")));
      return res;
    }
  
    bool run(const Stack *s1, const Stack *s2, Mesh* m, Mesh* m2, bool relabel);


  };

  ///@}
}

#endif
