//
// This file is part of MorphoGraphX - https://www.MorphoGraphX.org  (@RichardSmithLab)
//
// MorphoGraphX development is led by the Richard S. Smith lab at the John Innes Centre, Norwich, UK
//
// If you use MorphoGraphX in your work, please cite:
//   https://doi.org/10.7554/eLife.72601
//
// For support please see the image.sc forum:
//   https://forum.image.sc/tag/MorphoGraphX
//
// MorphoGraphX is copyright by its authors, contributors, and/or their employers.
//
// MorphoGraphX is free software, and is licensed under the terms of the 
// GNU General Public License https://www.gnu.org/licenses/.
//
//
// This is a class for guard objects using OpenMP
// It is adapted from the book
// "Pattern-Oriented Software Architecture". 
// Taken from http://www.thinkingparallel.com - Michael Suess
//
#ifndef OMP_GUARD_HPP
#define OMP_GUARD_HPP
 
#include <Config.hpp>
#include <omp.h>

namespace mgx
{ 
  /** 
   * This is a class for guard objects using OpenMP
   *  It is adapted from the book
   *  "Pattern-Oriented Software Architecture". 
   *  Taken from http://www.thinkingparallel.com - Michael Suess
   */
  class mgx_EXPORT OMPGuard 
  {
  public:
    /** Acquire the lock and store a pointer to it */
    OMPGuard (omp_lock_t &lock);
    /** Destruct guard object */
    ~OMPGuard();
   
  private:
    /** Set the lock explicitly */
    void acquire();
    /** Release the lock explicitly (owner thread only!) */
    void release();

    omp_lock_t *_lock;  // pointer to our lock
    bool _owner;   // is this object the owner of the lock?
     
    // Disallow copies or assignment
    OMPGuard(const OMPGuard &);
    void operator=(const OMPGuard &);
  };
}
#endif 
