//
// This file is part of MorphoGraphX - https://www.MorphoGraphX.org  (@RichardSmithLab)
//
// MorphoGraphX development is led by the Richard S. Smith lab at the John Innes Centre, Norwich, UK
//
// If you use MorphoGraphX in your work, please cite:
//   https://doi.org/10.7554/eLife.72601
//
// For support please see the image.sc forum:
//   https://forum.image.sc/tag/MorphoGraphX
//
// MorphoGraphX is copyright by its authors, contributors, and/or their employers.
//
// MorphoGraphX is free software, and is licensed under the terms of the 
// GNU General Public License https://www.gnu.org/licenses/.
//
#ifndef PROCESSTHREAD_HPP
#define PROCESSTHREAD_HPP

#include <Process.hpp>

#include <QEvent>
#include <QMutex>
#include <QThread>

namespace mgx 
{
  class mgx_EXPORT ProcessThread : public QThread 
  {
    Q_OBJECT
  public:
    ProcessThread(Process* proc, Process::ProcessAction pAction, QObject* parent)
      : QThread(parent), process(proc), processAction(pAction)  {}
  
    virtual ~ProcessThread() {}
  
    void run();
  
    bool exitStatus() const 
    {
      return _status;
    }
    QString errorMessage() const 
    {
      return _error;
    }
    QString warningMessage() const 
    {
      return _warning;
    }
  
  protected:
    Process* process;
    Process::ProcessAction processAction;
    bool _status;
    QString _error, _warning;
  };
}
#endif
