//
// This file is part of MorphoGraphX - https://www.MorphoGraphX.org  (@RichardSmithLab)
//
// MorphoGraphX development is led by the Richard S. Smith lab at the John Innes Centre, Norwich, UK
//
// If you use MorphoGraphX in your work, please cite:
//   https://doi.org/10.7554/eLife.72601
//
// For support please see the image.sc forum:
//   https://forum.image.sc/tag/MorphoGraphX
//
// MorphoGraphX is copyright by its authors, contributors, and/or their employers.
//
// MorphoGraphX is free software, and is licensed under the terms of the 
// GNU General Public License https://www.gnu.org/licenses/.
//
#ifndef R_PROCESSES_HPP
#define R_PROCESSES_HPP

#include <Geometry.hpp>
#include <Process.hpp>
#include "Mesh.hpp"

#include <QtGui>
#include <QMainWindow>

#include "ui_RWindow.h"
#include "ui_RWindowAdvanced.h"

using namespace std;

namespace mgx 
{

  class RWindow : public QMainWindow
  {
    Q_OBJECT

  public:
    explicit RWindow(QWidget *parent)
    {
      ui.setupUi(this);
    };
    Ui::rWindow ui;
  };

  class RWindowAdvanced : public QMainWindow
  {
    Q_OBJECT

  public:
    explicit RWindowAdvanced(QWidget *parent)
    {
      ui.setupUi(this);
    };
    Ui::rWindowAdvanced ui;
  };

  /**
   * \class RHeatHist
   *
   * RHeatHist
   * R Test process
   */
  class RHeatHist : public Process
  {
  public:
    RHeatHist(const Process& process) : Process(process)
    {
      setName("Misc/R/Heatmap Histogram");
      setDesc("Display the current heat map as a histogram");
      setIcon(QIcon(":/images/CHull.png"));

      addParm("Heat Name","Heat Name","Heat"); // 0  
    }
    bool initialize(QWidget* parent);
  };

  /**
   * \class RCorrelation
   *
   * RCorrelation
   * R Test process
   */
  class RCorrelation : public Process
  {
  public:
    RCorrelation(const Process& process) : Process(process)
    {
      setName("Misc/R/Heatmap Correlate");
      setDesc("Display the current heat map as a histogram");
      setIcon(QIcon(":/images/CHull.png"));

      addParm("X Heat","X Heat to plot, empty for current",""); // 0  
      addParm("Y Heat","Y Heat to plot, empty for current",""); // 1  
      addParm("Method","Method of correlation to use, 'None' for scatter plot only","None",QStringList() << "Pearson" << "Spearman" << "Kendall" << "None"); // 2
      addParm("Draw Line","Put a best file line on the plot","No",booleanChoice()); // 3          
    }
    bool initialize(QWidget* parent);
  };

  /**
   * \class RMeanTest
   *
   * RMeanTest
   * R Test process
   */
  class RMeanTest : public Process
  {
  public:
    RMeanTest(const Process& process) : Process(process)
    {
      setName("Misc/R/Mean Test");
      setDesc("Test if means are different for mesh 1 & 2 and display plot");
      setIcon(QIcon(":/images/CHull.png"));

      addParm("Test", "Test to use", "T-Test",QStringList() << "T-Test" << "Wilcox"); // 0        
    }
    bool initialize(QWidget* parent);
  };

  /**
   * \class RMeanTest
   *
   * RMeanTest
   * R Test process
   */
  class RAdvanced : public Process
  {
    Q_OBJECT
  public:

    RWindowAdvanced *rWind;

    QString type;

    QString measureX, measureY, measureComparison;

    QString correlationType, comparisonType, fittedLine, selectedType, colorType;

    std::set<int> selectedLabels;

    std::map<int, double> heatMapX, heatMapY;
    std::map<int, double> parentLabels;

    RAdvanced(const Process& process) : Process(process)
    {
      setName("Misc/R/Create R Plot");
      setDesc("Opens a GUI for different options to create graph plots from the generated attribute map data of the meshes");
      setIcon(QIcon(":/images/CHull.png"));
    }

    bool initialize(QWidget* parent);

    public slots:
      void setMeasure();
      void setCorrelation(QString type);
      void setFitted(QString type);
      void setSelected(QString type);
      void setColor(QString type);
      void updateRPlot();

      void setTestMeasure();
      void updateRTestPlot();
  };

  /**
   * \class RMeanTest
   *
   * RMeanTest
   * R Test process
   */
  class RStudio : public Process
  {
  public:
    RStudio(const Process& process) : Process(process)
    {
      setName("Misc/R/Send Data to R");
      setDesc("Creates a data frame file for R and starts Rstudio");
      setIcon(QIcon(":/images/CHull.png"));

      addParm("Data Frame","Name of the data frame",""); // 0          
    }

    bool initialize(QWidget* parent);
  };
}

#endif
