//
// This file is part of MorphoGraphX - https://www.MorphoGraphX.org  (@RichardSmithLab)
//
// MorphoGraphX development is led by the Richard S. Smith lab at the John Innes Centre, Norwich, UK
//
// If you use MorphoGraphX in your work, please cite:
//   https://doi.org/10.7554/eLife.72601
//
// For support please see the image.sc forum:
//   https://forum.image.sc/tag/MorphoGraphX
//
// MorphoGraphX is copyright by its authors, contributors, and/or their employers.
//
// MorphoGraphX is free software, and is licensed under the terms of the 
// GNU General Public License https://www.gnu.org/licenses/.
//
#ifndef STACK_UTILS_HPP
#define STACK_UTILS_HPP

#include <Store.hpp>

/**
 * \file StackUtils.hpp
 * Contains various stack global functions
 */

namespace mgx 
{
  /// Relabel an image, possibly with a random ordering
  int relabelImage(const HVecUS &input, HVecUS &output, int start = 1, int step = 1, bool random = false);
}

#endif
