//
// This file is part of MorphoGraphX - https://www.MorphoGraphX.org  (@RichardSmithLab)
//
// MorphoGraphX development is led by the Richard S. Smith lab at the John Innes Centre, Norwich, UK
//
// If you use MorphoGraphX in your work, please cite:
//   https://doi.org/10.7554/eLife.72601
//
// For support please see the image.sc forum:
//   https://forum.image.sc/tag/MorphoGraphX
//
// MorphoGraphX is copyright by its authors, contributors, and/or their employers.
//
// MorphoGraphX is free software, and is licensed under the terms of the 
// GNU General Public License https://www.gnu.org/licenses/.
//
#ifndef VIS_FLAGS_HPP
#define VIS_FLAGS_HPP

struct VisClipFlags
{
  uchar enabled : 1;
  uchar grid : 1;
};

struct VisCutSurfFlags
{
  uchar enabled : 1;
  uchar grid : 1;
  uchar plane : 1;
  uchar axis : 1;
  uchar bezier : 1;
};

struct VisStackFlags
{
  uchar main : 1;
  uchar work : 1;
  uchar surface : 1;
  uchar mesh : 1;
  uchar lines : 1;
  uchar points : 1;
};

union VisFlags
{
  VisClipFlags clipFlags;
  VisCutSurfFlags cutSurfFlags;
  VisStackFlags stackFlags;
  ulong iFlags;
};

#endif
