//
// This file is part of MorphoGraphX - https://www.MorphoGraphX.org  (@RichardSmithLab)
//
// MorphoGraphX development is led by the Richard S. Smith lab at the John Innes Centre, Norwich, UK
//
// If you use MorphoGraphX in your work, please cite:
//   https://doi.org/10.7554/eLife.72601
//
// For support please see the image.sc forum:
//   https://forum.image.sc/tag/MorphoGraphX
//
// MorphoGraphX is copyright by its authors, contributors, and/or their employers.
//
// MorphoGraphX is free software, and is licensed under the terms of the 
// GNU General Public License https://www.gnu.org/licenses/.
//
#ifndef WALL_DATA_H
#define WALL_DATA_H

#include <Config.hpp>
#include <Colors.hpp>

/**
 * \file WallData.hpp
 *
 * This file contains the definition of the wall data. Walls are edges in the cell 
 * graph and summarize the data along the walls between cells.
 */
namespace mgx 
{
  /**
   * \class WallData WallData.hpp <WallData.hpp>
   *
   * This class contains the definition of the wall data. Walls are edges in the cell 
   * graph and summarize the data along the walls between cells.
   */
  struct WallData 
  {
    double length; /// the length of the cell wall
    double area;   /// are of the cell interface
    Colorb color;  /// Wall edge color

    WallData() : length(0), area(0), color(0,0,0,0) {}
    ~WallData() {}
  };
}

#endif
