//
// This file is part of MorphoGraphX - https://www.MorphoGraphX.org  (@RichardSmithLab)
//
// MorphoGraphX development is led by the Richard S. Smith lab at the John Innes Centre, Norwich, UK
//
// If you use MorphoGraphX in your work, please cite:
//   https://doi.org/10.7554/eLife.72601
//
// For support please see the image.sc forum:
//   https://forum.image.sc/tag/MorphoGraphX
//
// MorphoGraphX is copyright by its authors, contributors, and/or their employers.
//
// MorphoGraphX is free software, and is licensed under the terms of the 
// GNU General Public License https://www.gnu.org/licenses/.
//
#ifndef CUDA_GLOBAL_H
#define CUDA_GLOBAL_H

/*
 * \file CudaGlobal.hpp
 *
 * Defines global items for cuda
 */
#ifdef __CUDACC__
  #define CU_HOST_DEVICE __host__ __device__ inline
#else
  #define CU_HOST_DEVICE inline
#endif

#ifdef WIN32
  #ifdef THRUST_BACKEND_CUDA
    #ifdef cuda_EXPORTS
      #define cuda_EXPORT extern "C" __declspec(dllexport)
    #else
      #define cuda_EXPORT extern "C" __declspec(dllimport)
    #endif
  #else
    #ifdef mgx_EXPORTS
      #define cuda_EXPORT extern "C" __declspec(dllexport)
    #else
      #define cuda_EXPORT extern "C" __declspec(dllimport)
    #endif
  #endif
#else
  #define cuda_EXPORT
#endif

#define CU_EPSILON 1e-10f

#endif
