//
// This file is part of MorphoGraphX - https://www.MorphoGraphX.org  (@RichardSmithLab)
//
// MorphoGraphX development is led by the Richard S. Smith lab at the John Innes Centre, Norwich, UK
//
// If you use MorphoGraphX in your work, please cite:
//   https://doi.org/10.7554/eLife.72601
//
// For support please see the image.sc forum:
//   https://forum.image.sc/tag/MorphoGraphX
//
// MorphoGraphX is copyright by its authors, contributors, and/or their employers.
//
// MorphoGraphX is free software, and is licensed under the terms of the 
// GNU General Public License https://www.gnu.org/licenses/.
//
#ifndef DIST_OBJECT_CUDA_HPP
#define DIST_OBJECT_CUDA_HPP

#include <Cuda.hpp>
#include <ThrustTypes.hpp>

// Public Cuda interface methods
namespace mgx
{
  template<typename T1, typename T2> 
  int mgx_EXPORT copyGPU(T1 *src, T2 *dst)
  {
    if(!src or !dst)
      return 1;
    *dst = *src;

     return 0;
  }

  template<typename T> 
  int mgx_EXPORT allocGPU(T **vec, size_t n)
  {
    if(n == 0) {
      if(*vec) {
        delete *vec;
        *vec = 0;
      }
      return 1;
    }
    if(!*vec)
      *vec = new T;
    (*vec)->resize(n);

    return 0;
  }
} 
#endif
