//
// This file is part of MorphoGraphX - https://www.MorphoGraphX.org  (@RichardSmithLab)
//
// MorphoGraphX development is led by the Richard S. Smith lab at the John Innes Centre, Norwich, UK
//
// If you use MorphoGraphX in your work, please cite:
//   https://doi.org/10.7554/eLife.72601
//
// For support please see the image.sc forum:
//   https://forum.image.sc/tag/MorphoGraphX
//
// MorphoGraphX is copyright by its authors, contributors, and/or their employers.
//
// MorphoGraphX is free software, and is licensed under the terms of the 
// GNU General Public License https://www.gnu.org/licenses/.
//
#ifndef AUTO_TRIM_HPP
#define AUTO_TRIM_HPP

#include <Process.hpp>

namespace mgx 
{
  /**
   * \class AutoTrim AutoTrim.hpp <AutoTrim.hpp>
   *
   * Trim stack boundary box (BBox) to keep only non-empty part. A voxel is
   * considered empty if its intensity is less or equal to the threshold.
   *
   * \ingroup StackProcess
   */
  class mgxBase_EXPORT AutoTrim : public Process {
  public:
    AutoTrim(const Process& process) : Process(process) 
    {
      setName("Stack/Canvas/AutoTrim");
      setDesc("Trim stack boundary box (BBox) to keep only non-empty part.\n"
      "A voxel is considered empty if its intensity is less or equal to the threshold.");
	  setIcon(QIcon(":/images/AutoTrim.png"));
	  
      addParm("Threshold","Voxels below this threshold are considered empty.","0");				
	}
  
    bool run()
    {
      if(!checkState().stack(STACK_ANY))
        return false;
  
      return run(currentStack(), currentStack()->currentStore(), parm("Threshold").toInt());
    }
  
    bool run(Stack* stack, Store* store, int threshold);
  
  };
}
#endif
