//
// This file is part of MorphoGraphX - https://www.MorphoGraphX.org  (@RichardSmithLab)
//
// MorphoGraphX development is led by the Richard S. Smith lab at the John Innes Centre, Norwich, UK
//
// If you use MorphoGraphX in your work, please cite:
//   https://doi.org/10.7554/eLife.72601
//
// For support please see the image.sc forum:
//   https://forum.image.sc/tag/MorphoGraphX
//
// MorphoGraphX is copyright by its authors, contributors, and/or their employers.
//
// MorphoGraphX is free software, and is licensed under the terms of the 
// GNU General Public License https://www.gnu.org/licenses/.
//
#ifndef CELL_DATA_HPP
#define CELL_DATA_HPP

/**
 * \file CellData.hpp
 *
 * This file contains the definition of a cell.
 */

#include <Config.hpp>
#include <Geometry.hpp>
#include <VVGraph.hpp>
#include <VertexData.hpp>
#include <EdgeData.hpp>
#include <Colors.hpp>

namespace mgx 
{
  /**
   * \class CellData CellData.hpp <CellData.hpp>
   *
   * This class defines the properties of a cell, a vertex in the cell graph.
   */
  class CellData 
  {
  public:
    Point3d pos;     ///< Center position of the cell
    Point3d nrml;    ///< Cell normal
    double area;     ///< Area of the cell
    double volume;   ///< Volume for a 3D cell
    intptr_t vId;    ///< Vertex id in main S graph
    int label;       ///< Cell label
    Colorb color;    ///< Cell center color
    int saveId;      ///< Used when saving
    VVGraph<VertexData, EdgeData> S;  ///< Graph for the cell

    // Constructor, set initial values
    CellData() : pos(0, 0, 0), nrml(0, 0, 0), area(0), volume(0), vId(0),
      label(0), color(0,0,0,0), saveId(0) {}

    ~CellData() {}
  };
}

#endif
