//
// This file is part of MorphoGraphX - https://www.MorphoGraphX.org  (@RichardSmithLab)
//
// MorphoGraphX development is led by the Richard S. Smith lab at the John Innes Centre, Norwich, UK
//
// If you use MorphoGraphX in your work, please cite:
//   https://doi.org/10.7554/eLife.72601
//
// For support please see the image.sc forum:
//   https://forum.image.sc/tag/MorphoGraphX
//
// MorphoGraphX is copyright by its authors, contributors, and/or their employers.
//
// MorphoGraphX is free software, and is licensed under the terms of the 
// GNU General Public License https://www.gnu.org/licenses/.
//
#ifndef CLAMP_H
#define CLAMP_H

#include <Config.hpp>

/**
 * \file Clamp.hpp
 *
 * Defines the clamp function
 */

//#include <config.h>
namespace mgx 
{
  /**
   * \brief A function to clamp a value to a range.
   * \param val The start value.
   * \param min The minimum value of the range.
   * \param max The maximum value of the range.
   *
   *  If \c min is more than \c max, the function returns \c max.
   */
  template <class T> T clamp(const T& val, const T& min, const T& max)
  {
    if(min >= max)
      return max;
    else if(val < min)
      return min;
    else if(val > max)
      return max;
    else
      return val;
  }
}

#endif
