//
// This file is part of MorphoGraphX - https://www.MorphoGraphX.org  (@RichardSmithLab)
//
// MorphoGraphX development is led by the Richard S. Smith lab at the John Innes Centre, Norwich, UK
//
// If you use MorphoGraphX in your work, please cite:
//   https://doi.org/10.7554/eLife.72601
//
// For support please see the image.sc forum:
//   https://forum.image.sc/tag/MorphoGraphX
//
// MorphoGraphX is copyright by its authors, contributors, and/or their employers.
//
// MorphoGraphX is free software, and is licensed under the terms of the 
// GNU General Public License https://www.gnu.org/licenses/.
//
#ifndef COLOR_MAP_HPP
#define COLOR_MAP_HPP

#include <Config.hpp>
#include <Color.hpp>

namespace mgx
{
  typedef Vector<2, float> Point2f;
  typedef Vector<4, float> Point4f;

  class mgx_EXPORT ColorMap
  {
  public:
    ColorMap(std::vector<Colorb> *cols, Point2f *bnds) 
      : colorsP(cols), boundsP(bnds) {}
    ColorMap(std::vector<Colorb> *cols) 
      : colorsP(cols), boundsP(0) {}
  
    /// Get color by index
    Colorb getColor(int index) const;
    /// Interpolate color
    Colorb getColor(float s, float sBegin, float sEnd, int iBegin, int iEnd) const;
    Colorb getColor(float s, float sBegin, float sEnd) const;
    Colorb getColor(float s, int iBegin, int iEnd) const;
    Colorb getColor(float s) const;

    /// Set a preset Color Map
    bool setColorMap(const QString &map, uint sz = 0);
    /// Get the list of preset Color Maps
    QStringList getColorMapList() const;
    /// Does Color Map have bounds
    bool hasBounds() const { return boundsP != 0; }

    std::vector<Colorb> &colors() { return *colorsP; }
    const std::vector<Colorb> &colors() const { return *colorsP; }
    Point2f &bounds() { return hasBounds() ? *boundsP : dummyBounds; }
    const Point2f &bounds() const { return hasBounds() ? *boundsP : dummyBounds; }
  
  private:
    std::vector<Colorb> *colorsP;
    Point2f *boundsP;
    Point2f dummyBounds;
  };
}

#endif
