#ifndef MGX_CONFIG_HPP
#define MGX_CONFIG_HPP

#if defined(WIN64) && !defined(WIN32)
  #define WIN32
#endif

#if (defined(_WIN32) || defined(WIN64)) && !defined(WIN32)

  #ifdef mgx_EXPORTS
    #define mgx_EXPORT __declspec(dllexport)
  #else
    #define mgx_EXPORT __declspec(dllimport)
  #endif

  #ifdef mgxBase_EXPORTS
    #define mgxBase_EXPORT __declspec(dllexport)
  #else
    #define mgxBase_EXPORT __declspec(dllimport)
  #endif

  #ifdef mgxPython_EXPORTS
    #define mgxPython_EXPORT __declspec(dllexport)
  #else
    #define mgxPython_EXPORT __declspec(dllimport)
  #endif

  #define WINDOWS
  #include <windows.h>
  #undef max
  #undef min
  #include <cmath>

  #include <float.h>
#else
  #define cuda_EXPORT
  #define mgx_EXPORT
  #define mgxBase_EXPORT
  #define mgxPython_EXPORT
#endif

// Backend to use for operations that should be parallelized but not on GPU
/* #undef USE_TBB */
#define USE_OPENMP

#define THRUST_DEVICE_SYSTEM THRUST_DEVICE_SYSTEM_OMP
/* #undef THRUST_BACKEND_CUDA */
#define THRUST_BACKEND_OMP
/* #undef THRUST_BACKEND_TBB */

/* #undef MGX_USE_TR1 */

#define MGXPROCPATH "/usr/lib/MorphoGraphX/processes"
#define MGXPROCINCLPATH "/usr/include/MorphoGraphX"
#define MGXDOCPATH "/usr/share/doc/MorphoGraphX"
#define MGXRESPATH "/usr/share/MorphoGraphX"
#define MGXLIBPATH "/usr/lib/MorphoGraphX"

#endif

