//
// This file is part of MorphoGraphX - https://www.MorphoGraphX.org  (@RichardSmithLab)
//
// MorphoGraphX development is led by the Richard S. Smith lab at the John Innes Centre, Norwich, UK
//
// If you use MorphoGraphX in your work, please cite:
//   https://doi.org/10.7554/eLife.72601
//
// For support please see the image.sc forum:
//   https://forum.image.sc/tag/MorphoGraphX
//
// MorphoGraphX is copyright by its authors, contributors, and/or their employers.
//
// MorphoGraphX is free software, and is licensed under the terms of the 
// GNU General Public License https://www.gnu.org/licenses/.
//
#ifndef DataAnalyzer_H
#define DataAnalyzer_H

//#include "Geometry.hpp"
#include <math.h>
#include "Progress.hpp"

#include "Geometry.hpp"
#include "Types.hpp"

#include <stdio.h>
#include <cstdlib>
#include <iostream>
#include <string.h>
#include <fstream>
#include <dirent.h>

using namespace std;

namespace mgx {
//namespace process {

//using util::Vector;


struct SortResultData
{
  int cellType;
  int asocCortCell;
  double ratio, upper, lower;

  int measure;
};

struct FileDataType
{
  int cellNumber;
  int cellType;
  int asocCortCell;
  double radial;
  double lenLong, lenRad, lenCirc;
  double wallArea, cellVol;

  double GUS;
  double GUSUpper;
  double GUSLower;

  QString file;
};

struct FileEFactorDataType
{
  int cellType;
  int asocCortCell;
  double facLong, facRad, facCirc;
};

typedef std::vector<SortResultData> SortResultVector;
typedef std::vector<SortResultVector> SortResultVectorAll;
typedef std::vector<FileDataType> FileDataVector;
typedef std::vector<FileEFactorDataType> FileEFactorDataVector;
typedef Vector<2, int> Vec2i;
typedef std::vector<Vec2i> tagTypeVector;
typedef std::map<int, FileDataVector> tagDataMap;
typedef std::vector<QString> FilenameVector;

class DataAnalyzer
{

public:
  // global variables
  // X is always treatment and Y control
  bool perCellAvg;

  // possible tags (cell type, assoc cort cell)
  tagTypeVector tagTypesX, tagTypesY;

  // maps tags (celltype*100 + acc) to the data from the file data = [cell#, type, acc, [data columns], file]
  tagDataMap dataX, dataY;

  // vector with all filenames
  FilenameVector filenamesX, filenamesY;

  // data structure for the efactors
  FileEFactorDataVector efData;

  // data structure for the sorted results
  SortResultVectorAll resVecAll;

  bool saveEFactors(FileEFactorDataVector eFData, tagDataMap data, tagTypeVector tagTypes, FilenameVector filenames, QString folderOut);

  bool calcEFactors(SortResultVectorAll sortResVec, bool avg, int window, tagTypeVector tagTypes, FileEFactorDataVector& eFData);

  bool logRatio(double& ratio, double& upper, double& lower);

  bool sortData(tagDataMap data1, tagDataMap data2, tagTypeVector tagTypes);

  bool logRatio(double& ratio, double& upper, double& lower, std::vector<double> dataX, std::vector<double> dataY);

  bool analyze(QString folderX, QString folderY, QString folderOut, bool treatment, bool avg, int window, bool perCell);

  bool readCellData(QString folder, tagDataMap& tagData, tagTypeVector& tagTypes, FilenameVector& filenames);

  //double t005(double df);

  bool smoothAnalyzed(SortResultVectorAll& sortResVec, double window, tagTypeVector tagTypes);

  bool joinData(SortResultVectorAll sortResVec, tagDataMap data, tagTypeVector tagTypes, FilenameVector& filenames, QString folderOut);

  //double tIntervalB(double t, std::vector<double> x, std::vector<double> y);

  bool analyzeGUS(QString folderInput, /*QString folderOut, */QString gusFileExt, bool mergeBool, QString fileToMerge, bool avg, int window, QString upperFilter, double upperFilterValue, QString lowerFilter, double lowerFilterValue, IntDoubleMap& GUSInfo);

private:

};
//}
}

#endif

