//
// This file is part of MorphoGraphX - https://www.MorphoGraphX.org  (@RichardSmithLab)
//
// MorphoGraphX development is led by the Richard S. Smith lab at the John Innes Centre, Norwich, UK
//
// If you use MorphoGraphX in your work, please cite:
//   https://doi.org/10.7554/eLife.72601
//
// For support please see the image.sc forum:
//   https://forum.image.sc/tag/MorphoGraphX
//
// MorphoGraphX is copyright by its authors, contributors, and/or their employers.
//
// MorphoGraphX is free software, and is licensed under the terms of the 
// GNU General Public License https://www.gnu.org/licenses/.
//
#ifndef DIR_HPP
#define DIR_HPP

#include <Config.hpp>

#include <QDir>

namespace mgx 
{
  /// Returns the path relative to the current directory
  mgx_EXPORT QString stripCurrentDir(QString file);
  
  /// Remove a directory from the file path
  mgx_EXPORT QString stripDir(const QString& dir, QString file);
  
  /// Get the directory containing a file (base of the name only)
  mgx_EXPORT QString getDir(QString file);
  
  /// Set the current path
  mgx_EXPORT bool setCurrentPath(const QString& path);
  
  /// Get the current path
  mgx_EXPORT QString currentPath();
  
  /// Get the current path as a directory
  mgx_EXPORT QDir currentDir();
  
  /// Return the absolute path to a file
  mgx_EXPORT QString absoluteFilePath(QString filename);
  
  /// Return the absolute file path, resolving things like environement variables and '~' for $HOME
  mgx_EXPORT QString resolvePath(QString path);
}

#endif
