//
// This file is part of MorphoGraphX - https://www.MorphoGraphX.org  (@RichardSmithLab)
//
// MorphoGraphX development is led by the Richard S. Smith lab at the John Innes Centre, Norwich, UK
//
// If you use MorphoGraphX in your work, please cite:
//   https://doi.org/10.7554/eLife.72601
//
// For support please see the image.sc forum:
//   https://forum.image.sc/tag/MorphoGraphX
//
// MorphoGraphX is copyright by its authors, contributors, and/or their employers.
//
// MorphoGraphX is free software, and is licensed under the terms of the 
// GNU General Public License https://www.gnu.org/licenses/.
//
#ifndef DIST_MATRIX_PROTO_HPP
#define DIST_MATRIX_PROTO_HPP

#include <DistObject.hpp>
#include <ThrustTypes.hpp>

/**
 * Function prototypes for distributed matrix library.
 */
namespace mgx
{
  // Cuda functions (compiled with nvcc)
  template<typename T> 
  int multGPU(T *v, typename T::value_type::value_type a, T *r);

  template<typename T> 
	int multGPU(T *v1, T *v2, typename T::value_type::value_type &r);

  template<typename TM, typename TV> 
  int multGPU(DeviceVu *nb, TM *mv, TM *me, TV *v, TV *r);

  template<typename T> 
  int addToDiagGPU(typename T::value_type::value_type a, T *r);

  template<typename T>
  int addGPU(T *v1, T *v2, T *r);
 
  template<typename T>
  int subtractGPU(T *v1, T *v2, T *r);

  template<typename T> 
  int fillGPU(typename T::value_type::value_type a, T *r);

  template<typename T> 
  int minGPU(T *v, typename T::value_type::value_type &r);

  template<typename T> 
  int maxGPU(T *v, typename T::value_type::value_type &r);

  template<typename T> 
  int saxpyGPU(T *v1, T *v2, typename T::value_type::value_type a, T *r);

  template<typename T> 
  int jacobiPreCondGPU(DeviceVu *nb, T *mv, T *me, T *av, T *ae);
}
#endif
