//
// This file is part of MorphoGraphX - https://www.MorphoGraphX.org  (@RichardSmithLab)
//
// MorphoGraphX development is led by the Richard S. Smith lab at the John Innes Centre, Norwich, UK
//
// If you use MorphoGraphX in your work, please cite:
//   https://doi.org/10.7554/eLife.72601
//
// For support please see the image.sc forum:
//   https://forum.image.sc/tag/MorphoGraphX
//
// MorphoGraphX is copyright by its authors, contributors, and/or their employers.
//
// MorphoGraphX is free software, and is licensed under the terms of the 
// GNU General Public License https://www.gnu.org/licenses/.
//
#ifndef EDGE_DATA_H
#define EDGE_DATA_H

#include <Config.hpp>
#include <Colors.hpp>

/**
 * \file EdgeData.hpp
 *
 * This file contains the definition of an edge data.
 */
namespace mgx 
{
  /**
   * \class EdgeData EdgeData.hpp <EdgeData.hpp>
   *
   * This class defines the fields in the graph edges.
   */
  struct EdgeData 
  {
    Colorb color;       ///< Color to draw edge

    EdgeData() : color(0,0,0,0) {}
    ~EdgeData() {}
  };
}

#endif
