//
// This file is part of MorphoGraphX - https://www.MorphoGraphX.org  (@RichardSmithLab)
//
// MorphoGraphX development is led by the Richard S. Smith lab at the John Innes Centre, Norwich, UK
//
// If you use MorphoGraphX in your work, please cite:
//   https://doi.org/10.7554/eLife.72601
//
// For support please see the image.sc forum:
//   https://forum.image.sc/tag/MorphoGraphX
//
// MorphoGraphX is copyright by its authors, contributors, and/or their employers.
//
// MorphoGraphX is free software, and is licensed under the terms of the 
// GNU General Public License https://www.gnu.org/licenses/.
//
#ifndef EDGE_DETECT_ANGLE_HPP
#define EDGE_DETECT_ANGLE_HPP

#include <ITKConfig.hpp>
#include <ITKProcess.hpp>

#include <StackProcessMorphology.hpp>

namespace mgx
{
  mgxITK_EXPORT class EdgeDetectAngle : public Process {
  public:
    EdgeDetectAngle(const Process& process) : Process(process) 
    {
	  setName("Stack/Morphology/Edge Detect Angle");
	  setDesc("Do another pass of edge detection with the stack rotated to a new Z direction \n"
	  "This process requires a previous Edge Detect result in the work stack and uses \n"
	  "the parameters from that process");
	  setIcon(QIcon(":/images/EdgeDetectAngle.png"));

	  addParm("Fill Holes","Also run Fill Holes Process","No",booleanChoice());			
	}
  
    bool run()
    {
      if(!checkState().store(STORE_NON_EMPTY | STORE_NON_LABEL))
        return false;
                        
     EdgeDetectProcess *cellTypeMeasures;
     if(!getProcess("Stack/Morphology/Edge Detect", cellTypeMeasures))  
      throw(QString("EdgeDetectAngle: Unable to make EdgeDetectProcess process"));       

     Stack* stack = currentStack();
     Store* main = stack->main();
     Store* work = stack->work();
      
     bool res = run(stack, main, work, cellTypeMeasures->parm("Threshold").toFloat(), cellTypeMeasures->parm("Multiplier").toFloat(), 
                       cellTypeMeasures->parm("Adapt Factor").toFloat(), cellTypeMeasures->parm("Fill Value").toUInt(), 
                                                                                                 stringToBool(parm("Fill Holes")));
      return res;
    }
    bool run(Stack* s1, Store* input, Store* output, float threshold, float multiplier, float factor,
                    uint fillValue, bool fillHoles);
  
  };
}
#endif
