//
// This file is part of MorphoGraphX - https://www.MorphoGraphX.org  (@RichardSmithLab)
//
// MorphoGraphX development is led by the Richard S. Smith lab at the John Innes Centre, Norwich, UK
//
// If you use MorphoGraphX in your work, please cite:
//   https://doi.org/10.7554/eLife.72601
//
// For support please see the image.sc forum:
//   https://forum.image.sc/tag/MorphoGraphX
//
// MorphoGraphX is copyright by its authors, contributors, and/or their employers.
//
// MorphoGraphX is free software, and is licensed under the terms of the 
// GNU General Public License https://www.gnu.org/licenses/.
//
#ifndef MGX_FEATURES_H
#define MGX_FEATURES_H

#include <Config.hpp>

#ifdef __GNUC__
#  ifdef WIN32
#    include <_mingw.h>
#    define __GNUC_PREREQ(x, y) __MINGW_GNUC_PREREQ(x, y)
#  else
#    include <features.h>
#  endif
#  define __GNUC_LESS(x, y) (!__GNUC_PREREQ(x, y))
#endif

#ifndef __GNUC_LESS
#define __GNUC_LESS(x, y) 0
#endif

#endif
