//
// This file is part of MorphoGraphX - https://www.MorphoGraphX.org  (@RichardSmithLab)
//
// MorphoGraphX development is led by the Richard S. Smith lab at the John Innes Centre, Norwich, UK
//
// If you use MorphoGraphX in your work, please cite:
//   https://doi.org/10.7554/eLife.72601
//
// For support please see the image.sc forum:
//   https://forum.image.sc/tag/MorphoGraphX
//
// MorphoGraphX is copyright by its authors, contributors, and/or their employers.
//
// MorphoGraphX is free software, and is licensed under the terms of the 
// GNU General Public License https://www.gnu.org/licenses/.
//
#ifndef GRAPHALGORITHMS_HPP
#define GRAPHALGORITHMS_HPP

#include <Misc.hpp>
#include <Subdivide.hpp>
#include <Attributes.hpp>

#include <queue>

//#include "DivisionAnalysisData.hpp"

using namespace std;

namespace mgx {


typedef std::pair<int, int> IntInt;
typedef std::pair<IntInt, double> IntIntDouble;


   mgx_EXPORT void matrixInverseGSL(std::vector<std::vector<double> >& inputM, std::vector<std::vector<double> >& outputM);
   mgx_EXPORT int systemSolveGSL(std::vector<std::vector<double> >& inputM, std::vector<double>& x);

   // calculates the betweenness centrality for the (unweighted) cell graph
   mgx_EXPORT void calcBetweenness(cellGraph &C, std::map<cell, double>& cellBetweenessMap);

   // calculates the betweenness centrality for the (weighted) cell graph
   mgx_EXPORT bool calcBetweenness(cellGraph &C, std::map<IntInt, double>& weights, std::map<cell, double>& cellBetweenessMap);

   mgx_EXPORT bool calcBetweenness(std::map<IntInt, double>& neighborhoodGraph, std::map<int, double>& cellBetweenessMap);

   // generate a weight map for the edges
   mgx_EXPORT std::map<IntInt, double> generateWeights(std::map<IntInt, double> neighborMap, bool constWeight);

   // generate an ordering for cells (bfs)
   mgx_EXPORT std::vector<cell> cuthillMckeeOrdering(cellGraph &C, std::map<cell, int>& cellOrder);
   mgx_EXPORT std::vector<cell> cuthillMckeeOrdering(cellGraph &C, std::map<cell, int>& cellOrder, const cell &minCell);

   mgx_EXPORT void reverseVector(std::vector<cell>& input);

}

#endif
