//
// This file is part of MorphoGraphX - https://www.MorphoGraphX.org  (@RichardSmithLab)
//
// MorphoGraphX development is led by the Richard S. Smith lab at the John Innes Centre, Norwich, UK
//
// If you use MorphoGraphX in your work, please cite:
//   https://doi.org/10.7554/eLife.72601
//
// For support please see the image.sc forum:
//   https://forum.image.sc/tag/MorphoGraphX
//
// MorphoGraphX is copyright by its authors, contributors, and/or their employers.
//
// MorphoGraphX is free software, and is licensed under the terms of the 
// GNU General Public License https://www.gnu.org/licenses/.
//
#ifndef INFORMATION_HPP
#define INFORMATION_HPP

#include <Config.hpp>

#include <QEvent>
#include <QString>
#include <QString>
#include <QTextStream>

class QMainWindow;

// RSS: It would be nice to get rid of this macro
//      processes can use setStatus(QString) instead.
#define SETSTATUS(msg)                             \
  do {                                             \
    QString __status_msg;                          \
    {                                              \
      QTextStream __status_msgstrm(&__status_msg); \
      __status_msgstrm << msg;                     \
    }                                              \
    setStatus(__status_msg); \
  } while(false)

// Convenience macro for debugging
#define DebugOut Information::out << __FILE__ << " " << __LINE__ << endl;

namespace mgx 
{
  mgx_EXPORT extern bool DEBUG;

  namespace Information 
	{
    mgx_EXPORT extern QTextStream out;
    mgx_EXPORT extern QTextStream err;
    
    mgx_EXPORT void init(QMainWindow* wnd);
    mgx_EXPORT void setStatus(const QString& text, bool alsoPrint = true);
  }
}
#endif
