//
// This file is part of MorphoGraphX - https://www.MorphoGraphX.org  (@RichardSmithLab)
//
// MorphoGraphX development is led by the Richard S. Smith lab at the John Innes Centre, Norwich, UK
//
// If you use MorphoGraphX in your work, please cite:
//   https://doi.org/10.7554/eLife.72601
//
// For support please see the image.sc forum:
//   https://forum.image.sc/tag/MorphoGraphX
//
// MorphoGraphX is copyright by its authors, contributors, and/or their employers.
//
// MorphoGraphX is free software, and is licensed under the terms of the 
// GNU General Public License https://www.gnu.org/licenses/.
//
#ifndef MGX_CAMERA_HPP
#define MGX_CAMERA_HPP

#include <MGXViewer/manipulatedCameraFrame.h>
#include <MGXViewer/camera.h>

// This class is overloaded so that the zoom behavior can be modified.
// In libqglviewer you cannot zoom very close, you jsut move through the
// surface.
// 
class MGXCameraFrame : public qglviewer::ManipulatedCameraFrame {
public:
  MGXCameraFrame();

  void wheelEvent(QWheelEvent* const event, qglviewer::Camera* const camera);

  float zoom() const { return _zoom; }
  void setZoom(float z) { _zoom = z; }

protected:
  float _zoom;
};

class MGXCamera : public qglviewer::Camera 
{
public:
  MGXCamera();

  void getOrthoWidthHeight(GLdouble& halfWidth, GLdouble& halfHeight) const;
  void resetZoom();
  void fitSphere(const qglviewer::Vec& center, float radius);
  virtual void addKeyFrameToPath(int i);
  virtual void playPath(int i);
  virtual void deletePath(int i);
  virtual void resetPath(int i);
  virtual void drawAllPaths();

  float zoom() const { return _frame->zoom(); }
  void setZoom(float z) { _frame->setZoom(z); }
  MGXCameraFrame* frame() { return _frame; }
  const MGXCameraFrame* frame() const { return _frame; }

protected:
  MGXCameraFrame* _frame;
};

#endif

