//
// This file is part of MorphoGraphX - https://www.MorphoGraphX.org  (@RichardSmithLab)
//
// MorphoGraphX development is led by the Richard S. Smith lab at the John Innes Centre, Norwich, UK
//
// If you use MorphoGraphX in your work, please cite:
//   https://doi.org/10.7554/eLife.72601
//
// For support please see the image.sc forum:
//   https://forum.image.sc/tag/MorphoGraphX
//
// MorphoGraphX is copyright by its authors, contributors, and/or their employers.
//
// MorphoGraphX is free software, and is licensed under the terms of the 
// GNU General Public License https://www.gnu.org/licenses/.
//
#ifndef MANGLING_H
#define MANGLING_H

#include <Config.hpp>

#include <string>

class QString;

namespace mgx 
{
  /**
   * Demangle all the words in the string.
   *
   * \returns The string with all symbols demangled.
   */
  mgx_EXPORT QString qdemangle(std::string s);
  /**
   * Demangle all the words in the string.
   *
   * \returns The string with all symbols demangled.
   */
  mgx_EXPORT std::string demangle(std::string s);
}
#endif
