//
// This file is part of MorphoGraphX - https://www.MorphoGraphX.org  (@RichardSmithLab)
//
// MorphoGraphX development is led by the Richard S. Smith lab at the John Innes Centre, Norwich, UK
//
// If you use MorphoGraphX in your work, please cite:
//   https://doi.org/10.7554/eLife.72601
//
// For support please see the image.sc forum:
//   https://forum.image.sc/tag/MorphoGraphX
//
// MorphoGraphX is copyright by its authors, contributors, and/or their employers.
//
// MorphoGraphX is free software, and is licensed under the terms of the 
// GNU General Public License https://www.gnu.org/licenses/.
//
#ifndef MESH_PROCESS_IMPORT_HPP
#define MESH_PROCESS_IMPORT_HPP
#include <Process.hpp>
#include <Misc.hpp>

namespace mgx
{
  class Load3DFrom2View : public Process
  {
  public:
    Load3DFrom2View(const Process& process) : Process(process)
    { 
      setName("Mesh/Import/Load 3D From 2View");
      setDesc("Load a mesh from the 3D from 2View software\n\n"
              "The input height map is generated by the 3D stereo reconstruction software\n"
              "of Routier-Kierzkowska A-L and Kwiatkowska D, Functional Plant Biology, 2008\n"
              "https://doi.org/10.1071/FP08047.\n\n"
              "The greyscale image used for the color is typically the left input image for the reconstruction");
      setIcon(QIcon(":/images/open.png"));

      addParm("Height File", "File name that holds height map", "Height.csv");
      addParm("Color File", "File name that holds color", "Color.tif");
      addParm("Scale", "Scaling for the image in xyz", "1.0 1.0 1.0");
    }

    bool run()
    {
		  return run(currentMesh(), parm("Height File"), parm("Color File"), stringToPoint3d(parm("Scale")));
    }

    bool run(Mesh *mesh, const QString &heightFile, const QString &colorFile, Point3d scale);
  };
}
#endif
