//
// This file is part of MorphoGraphX - https://www.MorphoGraphX.org  (@RichardSmithLab)
//
// MorphoGraphX development is led by the Richard S. Smith lab at the John Innes Centre, Norwich, UK
//
// If you use MorphoGraphX in your work, please cite:
//   https://doi.org/10.7554/eLife.72601
//
// For support please see the image.sc forum:
//   https://forum.image.sc/tag/MorphoGraphX
//
// MorphoGraphX is copyright by its authors, contributors, and/or their employers.
//
// MorphoGraphX is free software, and is licensed under the terms of the 
// GNU General Public License https://www.gnu.org/licenses/.
//
#ifndef MESH_PROCESSS_TRI_DATA_HPP
#define MESH_PROCESSS_TRI_DATA_HPP

#include <Process.hpp>


namespace mgx
{
  ///\addtogroup MeshProcess
  ///@{
  /**
   * \class StatsTriangleValues <ProcessCellAxis.hpp>
   */
  class mgxBase_EXPORT StatsTriangleValues : public Process 
  {
  public:
    StatsTriangleValues(const Process& process) : Process(process) 
    {
	  setName("Mesh/Triangle Data/Average Tri Value");
	  setDesc("Compute average of triangle values.");
	  setIcon(QIcon(":/images/MakeHeatMap.png"));	

	  addParm("Selection only","Compute only for selected triangles","Yes",booleanChoice());
	  addParm("Statistic","Type of statistic computed","Percentile", QStringList() << "WeightedAverage" << "Percentile");
	  addParm("Percentile","Value for percentile","50");	
	}
		
	bool initialize();  // , QWidget* parent);

    bool run()
    {
      if(!checkState().mesh(MESH_NON_EMPTY))
        return false;
      return run(currentMesh(), stringToBool(parm("Selection only")), parm("Statistic"), parm("Percentile").toFloat());
    }
  
    bool run(Mesh* mesh, bool selection, QString stat, float prc);
  };
}
#endif
