//
// This file is part of MorphoGraphX - https://www.MorphoGraphX.org  (@RichardSmithLab)
//
// MorphoGraphX development is led by the Richard S. Smith lab at the John Innes Centre, Norwich, UK
//
// If you use MorphoGraphX in your work, please cite:
//   https://doi.org/10.7554/eLife.72601
//
// For support please see the image.sc forum:
//   https://forum.image.sc/tag/MorphoGraphX
//
// MorphoGraphX is copyright by its authors, contributors, and/or their employers.
//
// MorphoGraphX is free software, and is licensed under the terms of the 
// GNU General Public License https://www.gnu.org/licenses/.
//
#ifndef PROCESS_DOCS_DIALOG_HPP
#define PROCESS_DOCS_DIALOG_HPP

#include <Config.hpp>
#include <Process.hpp>

#include <QDialog>

#include <memory>

class QTreeWidget;
class QTreeWidgetItem;

namespace Ui {
  class ProcessDocsDialog;
}

namespace mgx 
{
  class mgx_EXPORT ProcessDocsDialog : public QDialog
  {
    Q_OBJECT
  public:
    ProcessDocsDialog(QWidget *parent);
    virtual ~ProcessDocsDialog();
  
  protected slots:
    // Automatically connected slots
    void on_StackTreeWidget_currentItemChanged(QTreeWidgetItem* item, QTreeWidgetItem* previous);
    void on_MeshTreeWidget_currentItemChanged(QTreeWidgetItem* item, QTreeWidgetItem* previous);
    void on_MiscTreeWidget_currentItemChanged(QTreeWidgetItem* item, QTreeWidgetItem* previous);
  
    void on_StackFilter_textChanged(const QString& text);
    void on_MeshFilter_textChanged(const QString& text);
    void on_MiscFilter_textChanged(const QString& text);
  
  private:
    void updateDocView(ProcessDefinition* def);
    void findProcesses();
  
    //std::unique_ptr<Ui::ProcessDocsDialog> ui;
    Ui::ProcessDocsDialog *ui;
  };
}

#endif 

