//
// This file is part of MorphoGraphX - https://www.MorphoGraphX.org  (@RichardSmithLab)
//
// MorphoGraphX development is led by the Richard S. Smith lab at the John Innes Centre, Norwich, UK
//
// If you use MorphoGraphX in your work, please cite:
//   https://doi.org/10.7554/eLife.72601
//
// For support please see the image.sc forum:
//   https://forum.image.sc/tag/MorphoGraphX
//
// MorphoGraphX is copyright by its authors, contributors, and/or their employers.
//
// MorphoGraphX is free software, and is licensed under the terms of the 
// GNU General Public License https://www.gnu.org/licenses/.
//
#ifndef SUBDIVIDE_HPP
#define SUBDIVIDE_HPP

/**
 * \file Subdivide.hpp
 *
 * This file contains an object to inherit from when calling routines that do subdivision
 */
#include <Config.hpp>
#include <Types.hpp>
#include <Information.hpp>

namespace mgx 
{
  class Subdivide
  {
  public:
    Subdivide() {}
    virtual ~Subdivide() {}

    /**
     *  Update data when a cell divides
     *
     * \param c Old cell
     * \param l New cell left (direction is arbitrary)
     * \param r New cell right
     * \param t Adjacent cell on top
     * \param b Adjacent cell on bottom
     */
    virtual bool updateCellData(cell /*c*/, cell /*l*/, cell /*r*/) { return true; }

    /**
     *  Update data when an edge is split
     *
     * \param l Left vertex (direction is arbitrary)
     * \param r Right vertex 
     * \param v New vertex
     * \param s Position of insertion, (0-1) from left to right
     */
    virtual bool updateEdgeData(vertex /*l*/, vertex /*v*/, vertex /*r*/, double /*s*/) { return true; }
  };
}

#endif
