//
// This file is part of MorphoGraphX - https://www.MorphoGraphX.org  (@RichardSmithLab)
//
// MorphoGraphX development is led by the Richard S. Smith lab at the John Innes Centre, Norwich, UK
//
// If you use MorphoGraphX in your work, please cite:
//   https://doi.org/10.7554/eLife.72601
//
// For support please see the image.sc forum:
//   https://forum.image.sc/tag/MorphoGraphX
//
// MorphoGraphX is copyright by its authors, contributors, and/or their employers.
//
// MorphoGraphX is free software, and is licensed under the terms of the 
// GNU General Public License https://www.gnu.org/licenses/.
//
#ifndef UTIL_HPP
#define UTIL_HPP
/**
 * \file Util.hpp
 *
 * Common definitions and utilities
 * This file is shared by cuda, do not include headers that nvcc 
 * can't handle (i.e. Qt)
 */
#include <Config.hpp>
#include <cuda/CudaGlobal.hpp>

namespace mgx 
{
  // Min
  template <typename T> CU_HOST_DEVICE T min(const T a, const T b)
  {
    if(a <= b)
      return a;
    return b;
  }
  
  // Max
  template <typename T> T CU_HOST_DEVICE max(const T a, const T b)
  {
    if(a >= b)
      return a;
    return b;
  }
  
  // Trim to min/max
  template <typename T> CU_HOST_DEVICE T trim(const T x, const T minx, const T maxx) {
    return max(minx, min(maxx, x));
  }
}
#endif
