//
// This file is part of MorphoGraphX - https://www.MorphoGraphX.org  (@RichardSmithLab)
//
// MorphoGraphX development is led by the Richard S. Smith lab at the John Innes Centre, Norwich, UK
//
// If you use MorphoGraphX in your work, please cite:
//   https://doi.org/10.7554/eLife.72601
//
// For support please see the image.sc forum:
//   https://forum.image.sc/tag/MorphoGraphX
//
// MorphoGraphX is copyright by its authors, contributors, and/or their employers.
//
// MorphoGraphX is free software, and is licensed under the terms of the 
// GNU General Public License https://www.gnu.org/licenses/.
//
#ifndef VERTEXDATA_HPP
#define VERTEXDATA_HPP

/**
 * \file VertexData.hpp
 *
 * This file contains the definition of a vertex.
 */

#include <Config.hpp>
#include <Geometry.hpp>
#include <stdint.h>
#include <Colors.hpp>

namespace mgx 
{
  /**
   * \class VertexData VertexData.hpp <VertexData.hpp>
   *
   * This class defines the properties of a vertex
   */
  class VertexData 
  {
  public:
    Point3d pos;     ///< Position in space
    Point3d nrml;    ///< Normal vector 
    intptr_t minb;   ///< Closest border vertex 
    intptr_t cId;    ///< Id in cell graph

    float signal;    ///< Projected signal
    int label;       ///< Cell to which vertex belongs 
    Colorb color;    ///< Color to draw point
    int saveId;      ///< Used when saving vertex 

    char type;       ///< Type of vertex 
    bool selected;   ///< Is vertex selected? 
    bool margin;     ///< Is vertex on the margin? 

    // Constructor, set initial values
    VertexData() : pos(0, 0, 0), nrml(0, 0, 0), minb(0), cId(0),
      signal(.5), label(0), color(0,0,0,0), saveId(0), type('j'), selected(false), margin(false) {}

    ~VertexData() {}
  };
}

#endif
