//
// This file is part of MorphoGraphX - https://www.MorphoGraphX.org  (@RichardSmithLab)
//
// MorphoGraphX development is led by the Richard S. Smith lab at the John Innes Centre, Norwich, UK
//
// If you use MorphoGraphX in your work, please cite:
//   https://doi.org/10.7554/eLife.72601
//
// For support please see the image.sc forum:
//   https://forum.image.sc/tag/MorphoGraphX
//
// MorphoGraphX is copyright by its authors, contributors, and/or their employers.
//
// MorphoGraphX is free software, and is licensed under the terms of the 
// GNU General Public License https://www.gnu.org/licenses/.
//
// Derived from hdf_explorer, Copyright (C) 2016 Pedro Vicente
//

#ifndef HDF_VISIT_HPP
#define HDF_VISIT_HPP

#include <vector>
#include "hdf5.h"

/////////////////////////////////////////////////////////////////////////////////////////////////////
//h5visit_t
/////////////////////////////////////////////////////////////////////////////////////////////////////

struct H5O_info_added_t
{
  H5O_info_t oinfo;
  size_t added;
};
  

class h5visit_t
{
public:
  h5visit_t()
  {
  }

  // visit
  int visit(const char* file_name);

  // HDF5 object information
  std::vector < H5O_info_added_t > visit_info;

private:
  // callback function for H5Lvisit_by_name
  static herr_t visit_link_cb(hid_t loc_id, const char *name, const H5L_info_t *linfo, void *_op_data);
};

#endif
